package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataLicenseSetDetails(
    licenseConfigurationArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails = {
    import AwsEc2LaunchTemplateDataLicenseSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataLicenseSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails(
        licenseConfigurationArn.map(value => value)
      )
    def licenseConfigurationArn: Optional[NonEmptyString]
    def getLicenseConfigurationArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "licenseConfigurationArn",
        licenseConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly {
    override val licenseConfigurationArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseConfigurationArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.ReadOnly =
    new Wrapper(impl)
}
