package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails(
    max: Optional[Integer] = Optional.Absent,
    min: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails = {
    import AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
      .builder()
      .optionallyWith(max.map(value => value: java.lang.Integer))(_.max)
      .optionallyWith(min.map(value => value: java.lang.Integer))(_.min)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails(
          max.map(value => value),
          min.map(value => value)
        )
    def max: Optional[Integer]
    def min: Optional[Integer]
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly {
    override val max: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Integer)
    override val min: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly =
    new Wrapper(impl)
}
