package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails = {
    import AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails =
      zio.aws.securityhub.model
        .AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails(
          name.map(value => value),
          `type`.map(value => value),
          value.map(value => value)
        )
    def name: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly =
    new Wrapper(impl)
}
