package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudWatchAlarmDetails(
    actionsEnabled: Optional[Boolean] = Optional.Absent,
    alarmActions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    alarmArn: Optional[NonEmptyString] = Optional.Absent,
    alarmConfigurationUpdatedTimestamp: Optional[NonEmptyString] =
      Optional.Absent,
    alarmDescription: Optional[NonEmptyString] = Optional.Absent,
    alarmName: Optional[NonEmptyString] = Optional.Absent,
    comparisonOperator: Optional[NonEmptyString] = Optional.Absent,
    datapointsToAlarm: Optional[Integer] = Optional.Absent,
    dimensions: Optional[
      Iterable[zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails]
    ] = Optional.Absent,
    evaluateLowSampleCountPercentile: Optional[NonEmptyString] =
      Optional.Absent,
    evaluationPeriods: Optional[Integer] = Optional.Absent,
    extendedStatistic: Optional[NonEmptyString] = Optional.Absent,
    insufficientDataActions: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    metricName: Optional[NonEmptyString] = Optional.Absent,
    namespace: Optional[NonEmptyString] = Optional.Absent,
    okActions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    period: Optional[Integer] = Optional.Absent,
    statistic: Optional[NonEmptyString] = Optional.Absent,
    threshold: Optional[Double] = Optional.Absent,
    thresholdMetricId: Optional[NonEmptyString] = Optional.Absent,
    treatMissingData: Optional[NonEmptyString] = Optional.Absent,
    unit: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDetails = {
    import AwsCloudWatchAlarmDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDetails
      .builder()
      .optionallyWith(actionsEnabled.map(value => value: java.lang.Boolean))(
        _.actionsEnabled
      )
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        alarmArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.alarmArn)
      .optionallyWith(
        alarmConfigurationUpdatedTimestamp.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.alarmConfigurationUpdatedTimestamp)
      .optionallyWith(
        alarmDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.alarmDescription)
      .optionallyWith(
        alarmName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(
        comparisonOperator.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.comparisonOperator)
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        evaluateLowSampleCountPercentile.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.evaluateLowSampleCountPercentile)
      .optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(
        _.evaluationPeriods
      )
      .optionallyWith(
        extendedStatistic.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.extendedStatistic)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        namespace.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(period.map(value => value: java.lang.Integer))(_.period)
      .optionallyWith(
        statistic.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.statistic)
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(
        thresholdMetricId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.thresholdMetricId)
      .optionallyWith(
        treatMissingData.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.treatMissingData)
      .optionallyWith(
        unit.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCloudWatchAlarmDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudWatchAlarmDetails.wrap(buildAwsValue())
}
object AwsCloudWatchAlarmDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudWatchAlarmDetails =
      zio.aws.securityhub.model.AwsCloudWatchAlarmDetails(
        actionsEnabled.map(value => value),
        alarmActions.map(value => value),
        alarmArn.map(value => value),
        alarmConfigurationUpdatedTimestamp.map(value => value),
        alarmDescription.map(value => value),
        alarmName.map(value => value),
        comparisonOperator.map(value => value),
        datapointsToAlarm.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evaluateLowSampleCountPercentile.map(value => value),
        evaluationPeriods.map(value => value),
        extendedStatistic.map(value => value),
        insufficientDataActions.map(value => value),
        metricName.map(value => value),
        namespace.map(value => value),
        okActions.map(value => value),
        period.map(value => value),
        statistic.map(value => value),
        threshold.map(value => value),
        thresholdMetricId.map(value => value),
        treatMissingData.map(value => value),
        unit.map(value => value)
      )
    def actionsEnabled: Optional[Boolean]
    def alarmActions: Optional[List[NonEmptyString]]
    def alarmArn: Optional[NonEmptyString]
    def alarmConfigurationUpdatedTimestamp: Optional[NonEmptyString]
    def alarmDescription: Optional[NonEmptyString]
    def alarmName: Optional[NonEmptyString]
    def comparisonOperator: Optional[NonEmptyString]
    def datapointsToAlarm: Optional[Integer]
    def dimensions: Optional[List[
      zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly
    ]]
    def evaluateLowSampleCountPercentile: Optional[NonEmptyString]
    def evaluationPeriods: Optional[Integer]
    def extendedStatistic: Optional[NonEmptyString]
    def insufficientDataActions: Optional[List[NonEmptyString]]
    def metricName: Optional[NonEmptyString]
    def namespace: Optional[NonEmptyString]
    def okActions: Optional[List[NonEmptyString]]
    def period: Optional[Integer]
    def statistic: Optional[NonEmptyString]
    def threshold: Optional[Double]
    def thresholdMetricId: Optional[NonEmptyString]
    def treatMissingData: Optional[NonEmptyString]
    def unit: Optional[NonEmptyString]
    def getActionsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabled)
    def getAlarmActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("alarmActions", alarmActions)
    def getAlarmArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("alarmArn", alarmArn)
    def getAlarmConfigurationUpdatedTimestamp
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "alarmConfigurationUpdatedTimestamp",
      alarmConfigurationUpdatedTimestamp
    )
    def getAlarmDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescription)
    def getAlarmName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getComparisonOperator: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getDatapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getEvaluateLowSampleCountPercentile
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "evaluateLowSampleCountPercentile",
      evaluateLowSampleCountPercentile
    )
    def getEvaluationPeriods: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getExtendedStatistic: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatistic)
    def getInsufficientDataActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActions
      )
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOkActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("okActions", okActions)
    def getPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("period", period)
    def getStatistic: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getThresholdMetricId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("thresholdMetricId", thresholdMetricId)
    def getTreatMissingData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getUnit: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDetails
  ) extends zio.aws.securityhub.model.AwsCloudWatchAlarmDetails.ReadOnly {
    override val actionsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.actionsEnabled())
      .map(value => value: Boolean)
    override val alarmActions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val alarmArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val alarmConfigurationUpdatedTimestamp: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfigurationUpdatedTimestamp())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val alarmDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmDescription())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val alarmName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val comparisonOperator: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val datapointsToAlarm: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.datapointsToAlarm())
      .map(value => value: Integer)
    override val dimensions: Optional[List[
      zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
            .wrap(item)
        }.toList
      )
    override val evaluateLowSampleCountPercentile: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluateLowSampleCountPercentile())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val evaluationPeriods: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationPeriods())
      .map(value => value: Integer)
    override val extendedStatistic: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistic())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val insufficientDataActions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val metricName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val namespace: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val okActions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.okActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val period: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => value: Integer)
    override val statistic: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.statistic())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val threshold: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: Double)
    override val thresholdMetricId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thresholdMetricId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val treatMissingData: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatMissingData())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val unit: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDetails
  ): zio.aws.securityhub.model.AwsCloudWatchAlarmDetails.ReadOnly = new Wrapper(
    impl
  )
}
