package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFormationStackDriftInformationDetails(
    stackDriftStatus: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails = {
    import AwsCloudFormationStackDriftInformationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails
      .builder()
      .optionallyWith(
        stackDriftStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.stackDriftStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails
      .wrap(buildAwsValue())
}
object AwsCloudFormationStackDriftInformationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails =
      zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails(
        stackDriftStatus.map(value => value)
      )
    def stackDriftStatus: Optional[NonEmptyString]
    def getStackDriftStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stackDriftStatus", stackDriftStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails
  ) extends zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly {
    override val stackDriftStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackDriftStatus())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDriftInformationDetails
  ): zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly =
    new Wrapper(impl)
}
