package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateDetails(
    certificateAuthorityArn: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[NonEmptyString] = Optional.Absent,
    domainName: Optional[NonEmptyString] = Optional.Absent,
    domainValidationOptions: Optional[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
    ]] = Optional.Absent,
    extendedKeyUsages: Optional[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
    ]] = Optional.Absent,
    failureReason: Optional[NonEmptyString] = Optional.Absent,
    importedAt: Optional[NonEmptyString] = Optional.Absent,
    inUseBy: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    issuedAt: Optional[NonEmptyString] = Optional.Absent,
    issuer: Optional[NonEmptyString] = Optional.Absent,
    keyAlgorithm: Optional[NonEmptyString] = Optional.Absent,
    keyUsages: Optional[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage
    ]] = Optional.Absent,
    notAfter: Optional[NonEmptyString] = Optional.Absent,
    notBefore: Optional[NonEmptyString] = Optional.Absent,
    options: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions
    ] = Optional.Absent,
    renewalEligibility: Optional[NonEmptyString] = Optional.Absent,
    renewalSummary: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
    ] = Optional.Absent,
    serial: Optional[NonEmptyString] = Optional.Absent,
    signatureAlgorithm: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    subject: Optional[NonEmptyString] = Optional.Absent,
    subjectAlternativeNames: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails = {
    import AwsCertificateManagerCertificateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
      .builder()
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsages)
      .optionallyWith(
        failureReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        importedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.importedAt)
      .optionallyWith(
        inUseBy.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inUseBy)
      .optionallyWith(
        issuedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuedAt)
      .optionallyWith(
        issuer.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        keyAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyAlgorithm)
      .optionallyWith(
        keyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyUsages)
      .optionallyWith(
        notAfter.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.notAfter)
      .optionallyWith(
        notBefore.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.notBefore)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        renewalEligibility.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalEligibility)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(
        serial.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serial)
      .optionallyWith(
        signatureAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.signatureAlgorithm)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        subject.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails(
        certificateAuthorityArn.map(value => value),
        createdAt.map(value => value),
        domainName.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        importedAt.map(value => value),
        inUseBy.map(value => value),
        issuedAt.map(value => value),
        issuer.map(value => value),
        keyAlgorithm.map(value => value),
        keyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notAfter.map(value => value),
        notBefore.map(value => value),
        options.map(value => value.asEditable),
        renewalEligibility.map(value => value),
        renewalSummary.map(value => value.asEditable),
        serial.map(value => value),
        signatureAlgorithm.map(value => value),
        status.map(value => value),
        subject.map(value => value),
        subjectAlternativeNames.map(value => value),
        `type`.map(value => value)
      )
    def certificateAuthorityArn: Optional[NonEmptyString]
    def createdAt: Optional[NonEmptyString]
    def domainName: Optional[NonEmptyString]
    def domainValidationOptions: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]]
    def extendedKeyUsages: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]]
    def failureReason: Optional[NonEmptyString]
    def importedAt: Optional[NonEmptyString]
    def inUseBy: Optional[List[NonEmptyString]]
    def issuedAt: Optional[NonEmptyString]
    def issuer: Optional[NonEmptyString]
    def keyAlgorithm: Optional[NonEmptyString]
    def keyUsages: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]]
    def notAfter: Optional[NonEmptyString]
    def notBefore: Optional[NonEmptyString]
    def options: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ]
    def renewalEligibility: Optional[NonEmptyString]
    def renewalSummary: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ]
    def serial: Optional[NonEmptyString]
    def signatureAlgorithm: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def subject: Optional[NonEmptyString]
    def subjectAlternativeNames: Optional[List[NonEmptyString]]
    def `type`: Optional[NonEmptyString]
    def getCertificateAuthorityArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "certificateAuthorityArn",
        certificateAuthorityArn
      )
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getExtendedKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsages", extendedKeyUsages)
    def getFailureReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImportedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("importedAt", importedAt)
    def getInUseBy: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("inUseBy", inUseBy)
    def getIssuedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getKeyAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("keyUsages", keyUsages)
    def getNotAfter: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getRenewalEligibility: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalEligibility", renewalEligibility)
    def getRenewalSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getSerial: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serial", serial)
    def getSignatureAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getSubject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subject", subject)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly {
    override val certificateAuthorityArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainValidationOptions: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
    override val extendedKeyUsages: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.extendedKeyUsages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
            .wrap(item)
        }.toList
      )
    override val failureReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val importedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.importedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val inUseBy: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.inUseBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val issuedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.issuedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val issuer: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyAlgorithm: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyAlgorithm())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyUsages: Optional[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyUsages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage
            .wrap(item)
        }.toList
      )
    override val notAfter: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val notBefore: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val options: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions
          .wrap(value)
      )
    override val renewalEligibility: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalEligibility())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val renewalSummary: Optional[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.renewalSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
          .wrap(value)
      )
    override val serial: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serial())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val signatureAlgorithm: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signatureAlgorithm())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subject: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subjectAlternativeNames: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly =
    new Wrapper(impl)
}
