package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(
    onDemandAllocationStrategy: Optional[NonEmptyString] = Optional.Absent,
    onDemandBaseCapacity: Optional[Integer] = Optional.Absent,
    onDemandPercentageAboveBaseCapacity: Optional[Integer] = Optional.Absent,
    spotAllocationStrategy: Optional[NonEmptyString] = Optional.Absent,
    spotInstancePools: Optional[Integer] = Optional.Absent,
    spotMaxPrice: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
      .builder()
      .optionallyWith(
        onDemandAllocationStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.onDemandAllocationStrategy)
      .optionallyWith(
        onDemandBaseCapacity.map(value => value: java.lang.Integer)
      )(_.onDemandBaseCapacity)
      .optionallyWith(
        onDemandPercentageAboveBaseCapacity.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandPercentageAboveBaseCapacity)
      .optionallyWith(
        spotAllocationStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spotAllocationStrategy)
      .optionallyWith(spotInstancePools.map(value => value: java.lang.Integer))(
        _.spotInstancePools
      )
      .optionallyWith(
        spotMaxPrice.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spotMaxPrice)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(
          onDemandAllocationStrategy.map(value => value),
          onDemandBaseCapacity.map(value => value),
          onDemandPercentageAboveBaseCapacity.map(value => value),
          spotAllocationStrategy.map(value => value),
          spotInstancePools.map(value => value),
          spotMaxPrice.map(value => value)
        )
    def onDemandAllocationStrategy: Optional[NonEmptyString]
    def onDemandBaseCapacity: Optional[Integer]
    def onDemandPercentageAboveBaseCapacity: Optional[Integer]
    def spotAllocationStrategy: Optional[NonEmptyString]
    def spotInstancePools: Optional[Integer]
    def spotMaxPrice: Optional[NonEmptyString]
    def getOnDemandAllocationStrategy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "onDemandAllocationStrategy",
        onDemandAllocationStrategy
      )
    def getOnDemandBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("onDemandBaseCapacity", onDemandBaseCapacity)
    def getOnDemandPercentageAboveBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "onDemandPercentageAboveBaseCapacity",
        onDemandPercentageAboveBaseCapacity
      )
    def getSpotAllocationStrategy: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("spotAllocationStrategy", spotAllocationStrategy)
    def getSpotInstancePools: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("spotInstancePools", spotInstancePools)
    def getSpotMaxPrice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spotMaxPrice", spotMaxPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly {
    override val onDemandAllocationStrategy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandAllocationStrategy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val onDemandBaseCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.onDemandBaseCapacity())
      .map(value => value: Integer)
    override val onDemandPercentageAboveBaseCapacity: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandPercentageAboveBaseCapacity())
        .map(value => value: Integer)
    override val spotAllocationStrategy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotAllocationStrategy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val spotInstancePools: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.spotInstancePools())
      .map(value => value: Integer)
    override val spotMaxPrice: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.spotMaxPrice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly =
    new Wrapper(impl)
}
