package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(
    instancesDistribution: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
    ] = Optional.Absent,
    launchTemplate: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
      .builder()
      .optionallyWith(
        instancesDistribution.map(value => value.buildAwsValue())
      )(_.instancesDistribution)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(
          instancesDistribution.map(value => value.asEditable),
          launchTemplate.map(value => value.asEditable)
        )
    def instancesDistribution: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly
    ]
    def launchTemplate: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly
    ]
    def getInstancesDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("instancesDistribution", instancesDistribution)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly {
    override val instancesDistribution: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesDistribution())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
          .wrap(value)
      )
    override val launchTemplate: Optional[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplate())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly =
    new Wrapper(impl)
}
