package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait AdminStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.AdminStatus
}
object AdminStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.AdminStatus
  ): zio.aws.securityhub.model.AdminStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.AdminStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.AdminStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.securityhub.model.AdminStatus.DISABLE_IN_PROGRESS =>
      val r = DISABLE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AdminStatus =
      software.amazon.awssdk.services.securityhub.model.AdminStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.securityhub.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AdminStatus =
      software.amazon.awssdk.services.securityhub.model.AdminStatus.ENABLED
  }
  case object DISABLE_IN_PROGRESS
      extends zio.aws.securityhub.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AdminStatus =
      software.amazon.awssdk.services.securityhub.model.AdminStatus.DISABLE_IN_PROGRESS
  }
}
