package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionRemoteIpDetails(
    ipAddressV4: Optional[NonEmptyString] = Optional.Absent,
    organization: Optional[zio.aws.securityhub.model.IpOrganizationDetails] =
      Optional.Absent,
    country: Optional[zio.aws.securityhub.model.Country] = Optional.Absent,
    city: Optional[zio.aws.securityhub.model.City] = Optional.Absent,
    geoLocation: Optional[zio.aws.securityhub.model.GeoLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails = {
    import ActionRemoteIpDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
      .builder()
      .optionallyWith(
        ipAddressV4.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipAddressV4)
      .optionallyWith(organization.map(value => value.buildAwsValue()))(
        _.organization
      )
      .optionallyWith(country.map(value => value.buildAwsValue()))(_.country)
      .optionallyWith(city.map(value => value.buildAwsValue()))(_.city)
      .optionallyWith(geoLocation.map(value => value.buildAwsValue()))(
        _.geoLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly =
    zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(buildAwsValue())
}
object ActionRemoteIpDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionRemoteIpDetails =
      zio.aws.securityhub.model.ActionRemoteIpDetails(
        ipAddressV4.map(value => value),
        organization.map(value => value.asEditable),
        country.map(value => value.asEditable),
        city.map(value => value.asEditable),
        geoLocation.map(value => value.asEditable)
      )
    def ipAddressV4: Optional[NonEmptyString]
    def organization
        : Optional[zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly]
    def country: Optional[zio.aws.securityhub.model.Country.ReadOnly]
    def city: Optional[zio.aws.securityhub.model.City.ReadOnly]
    def geoLocation: Optional[zio.aws.securityhub.model.GeoLocation.ReadOnly]
    def getIpAddressV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
    def getOrganization: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("organization", organization)
    def getCountry
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Country.ReadOnly] =
      AwsError.unwrapOptionField("country", country)
    def getCity: ZIO[Any, AwsError, zio.aws.securityhub.model.City.ReadOnly] =
      AwsError.unwrapOptionField("city", city)
    def getGeoLocation
        : ZIO[Any, AwsError, zio.aws.securityhub.model.GeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("geoLocation", geoLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ) extends zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly {
    override val ipAddressV4: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddressV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val organization
        : Optional[zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organization())
        .map(value =>
          zio.aws.securityhub.model.IpOrganizationDetails.wrap(value)
        )
    override val country: Optional[zio.aws.securityhub.model.Country.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.country())
        .map(value => zio.aws.securityhub.model.Country.wrap(value))
    override val city: Optional[zio.aws.securityhub.model.City.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.city())
        .map(value => zio.aws.securityhub.model.City.wrap(value))
    override val geoLocation
        : Optional[zio.aws.securityhub.model.GeoLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoLocation())
        .map(value => zio.aws.securityhub.model.GeoLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ): zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly = new Wrapper(
    impl
  )
}
