package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait ThreatIntelIndicatorCategory {
  def unwrap: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory
}
object ThreatIntelIndicatorCategory {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory
  ): zio.aws.securityhub.model.ThreatIntelIndicatorCategory = value match {
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.BACKDOOR =>
      val r = BACKDOOR
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.CARD_STEALER =>
      val r = CARD_STEALER
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.COMMAND_AND_CONTROL =>
      val r = COMMAND_AND_CONTROL
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.DROP_SITE =>
      val r = DROP_SITE
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.EXPLOIT_SITE =>
      val r = EXPLOIT_SITE
      r
    case software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.KEYLOGGER =>
      val r = KEYLOGGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object BACKDOOR
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.BACKDOOR
  }
  case object CARD_STEALER
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.CARD_STEALER
  }
  case object COMMAND_AND_CONTROL
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.COMMAND_AND_CONTROL
  }
  case object DROP_SITE
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.DROP_SITE
  }
  case object EXPLOIT_SITE
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.EXPLOIT_SITE
  }
  case object KEYLOGGER
      extends zio.aws.securityhub.model.ThreatIntelIndicatorCategory {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory =
      software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory.KEYLOGGER
  }
}
