package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StandardsStatusReason(
    statusReasonCode: zio.aws.securityhub.model.StatusReasonCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsStatusReason = {
    import StandardsStatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsStatusReason
      .builder()
      .statusReasonCode(statusReasonCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StandardsStatusReason.ReadOnly =
    zio.aws.securityhub.model.StandardsStatusReason.wrap(buildAwsValue())
}
object StandardsStatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsStatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StandardsStatusReason =
      zio.aws.securityhub.model.StandardsStatusReason(statusReasonCode)
    def statusReasonCode: zio.aws.securityhub.model.StatusReasonCode
    def getStatusReasonCode
        : ZIO[Any, Nothing, zio.aws.securityhub.model.StatusReasonCode] =
      ZIO.succeed(statusReasonCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsStatusReason
  ) extends zio.aws.securityhub.model.StandardsStatusReason.ReadOnly {
    override val statusReasonCode: zio.aws.securityhub.model.StatusReasonCode =
      zio.aws.securityhub.model.StatusReasonCode.wrap(impl.statusReasonCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsStatusReason
  ): zio.aws.securityhub.model.StandardsStatusReason.ReadOnly = new Wrapper(
    impl
  )
}
