package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StandardsControlAssociationUpdate(
    standardsArn: NonEmptyString,
    securityControlId: NonEmptyString,
    associationStatus: zio.aws.securityhub.model.AssociationStatus,
    updatedReason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate = {
    import StandardsControlAssociationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate
      .builder()
      .standardsArn(NonEmptyString.unwrap(standardsArn): java.lang.String)
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .associationStatus(associationStatus.unwrap)
      .optionallyWith(
        updatedReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.updatedReason)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly =
    zio.aws.securityhub.model.StandardsControlAssociationUpdate
      .wrap(buildAwsValue())
}
object StandardsControlAssociationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.StandardsControlAssociationUpdate =
      zio.aws.securityhub.model.StandardsControlAssociationUpdate(
        standardsArn,
        securityControlId,
        associationStatus,
        updatedReason.map(value => value)
      )
    def standardsArn: NonEmptyString
    def securityControlId: NonEmptyString
    def associationStatus: zio.aws.securityhub.model.AssociationStatus
    def updatedReason: Optional[NonEmptyString]
    def getStandardsArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsArn)
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getAssociationStatus
        : ZIO[Any, Nothing, zio.aws.securityhub.model.AssociationStatus] =
      ZIO.succeed(associationStatus)
    def getUpdatedReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updatedReason", updatedReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate
  ) extends zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly {
    override val standardsArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.standardsArn())
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val associationStatus
        : zio.aws.securityhub.model.AssociationStatus =
      zio.aws.securityhub.model.AssociationStatus.wrap(impl.associationStatus())
    override val updatedReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate
  ): zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly =
    new Wrapper(impl)
}
