package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatefulRulesHeaderDetails(
    destination: Optional[NonEmptyString] = Optional.Absent,
    destinationPort: Optional[NonEmptyString] = Optional.Absent,
    direction: Optional[NonEmptyString] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    source: Optional[NonEmptyString] = Optional.Absent,
    sourcePort: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails = {
    import RuleGroupSourceStatefulRulesHeaderDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
      .builder()
      .optionallyWith(
        destination.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(
        destinationPort.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationPort)
      .optionallyWith(
        direction.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.direction)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        sourcePort.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourcePort)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatefulRulesHeaderDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails(
        destination.map(value => value),
        destinationPort.map(value => value),
        direction.map(value => value),
        protocol.map(value => value),
        source.map(value => value),
        sourcePort.map(value => value)
      )
    def destination: Optional[NonEmptyString]
    def destinationPort: Optional[NonEmptyString]
    def direction: Optional[NonEmptyString]
    def protocol: Optional[NonEmptyString]
    def source: Optional[NonEmptyString]
    def sourcePort: Optional[NonEmptyString]
    def getDestination: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destination", destination)
    def getDestinationPort: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getDirection: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("direction", direction)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
    def getSourcePort: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourcePort", sourcePort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly {
    override val destination: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationPort: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPort())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val direction: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.direction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val source: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourcePort: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePort())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly =
    new Wrapper(impl)
}
