package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirewallPolicyStatefulRuleGroupReferencesDetails(
    resourceArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails = {
    import FirewallPolicyStatefulRuleGroupReferencesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
      .builder()
      .optionallyWith(
        resourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
      .wrap(buildAwsValue())
}
object FirewallPolicyStatefulRuleGroupReferencesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails =
      zio.aws.securityhub.model
        .FirewallPolicyStatefulRuleGroupReferencesDetails(
          resourceArn.map(value => value)
        )
    def resourceArn: Optional[NonEmptyString]
    def getResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly {
    override val resourceArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ): zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly =
    new Wrapper(impl)
}
