package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHubResponse(
    hubArn: Optional[NonEmptyString] = Optional.Absent,
    subscribedAt: Optional[NonEmptyString] = Optional.Absent,
    autoEnableControls: Optional[Boolean] = Optional.Absent,
    controlFindingGenerator: Optional[
      zio.aws.securityhub.model.ControlFindingGenerator
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeHubResponse = {
    import DescribeHubResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
      .builder()
      .optionallyWith(
        hubArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hubArn)
      .optionallyWith(
        subscribedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subscribedAt)
      .optionallyWith(
        autoEnableControls.map(value => value: java.lang.Boolean)
      )(_.autoEnableControls)
      .optionallyWith(controlFindingGenerator.map(value => value.unwrap))(
        _.controlFindingGenerator
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeHubResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeHubResponse.wrap(buildAwsValue())
}
object DescribeHubResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeHubResponse =
      zio.aws.securityhub.model.DescribeHubResponse(
        hubArn.map(value => value),
        subscribedAt.map(value => value),
        autoEnableControls.map(value => value),
        controlFindingGenerator.map(value => value)
      )
    def hubArn: Optional[NonEmptyString]
    def subscribedAt: Optional[NonEmptyString]
    def autoEnableControls: Optional[Boolean]
    def controlFindingGenerator
        : Optional[zio.aws.securityhub.model.ControlFindingGenerator]
    def getHubArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hubArn", hubArn)
    def getSubscribedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subscribedAt", subscribedAt)
    def getAutoEnableControls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnableControls", autoEnableControls)
    def getControlFindingGenerator: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ControlFindingGenerator
    ] = AwsError.unwrapOptionField(
      "controlFindingGenerator",
      controlFindingGenerator
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ) extends zio.aws.securityhub.model.DescribeHubResponse.ReadOnly {
    override val hubArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hubArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subscribedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subscribedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val autoEnableControls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnableControls())
      .map(value => value: Boolean)
    override val controlFindingGenerator
        : Optional[zio.aws.securityhub.model.ControlFindingGenerator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlFindingGenerator())
        .map(value =>
          zio.aws.securityhub.model.ControlFindingGenerator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ): zio.aws.securityhub.model.DescribeHubResponse.ReadOnly = new Wrapper(impl)
}
