package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchUpdateStandardsControlAssociationsResponse(
    unprocessedAssociationUpdates: Optional[Iterable[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse = {
    import BatchUpdateStandardsControlAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
      .builder()
      .optionallyWith(
        unprocessedAssociationUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAssociationUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
      .wrap(buildAwsValue())
}
object BatchUpdateStandardsControlAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse =
      zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse(
        unprocessedAssociationUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAssociationUpdates: Optional[List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly
    ]]
    def getUnprocessedAssociationUpdates: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedAssociationUpdates",
      unprocessedAssociationUpdates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
  ) extends zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly {
    override val unprocessedAssociationUpdates: Optional[List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedAssociationUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
  ): zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
