package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetStandardsControlAssociationsResponse(
    standardsControlAssociationDetails: Iterable[
      zio.aws.securityhub.model.StandardsControlAssociationDetail
    ],
    unprocessedAssociations: Optional[
      Iterable[zio.aws.securityhub.model.UnprocessedStandardsControlAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse = {
    import BatchGetStandardsControlAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse
      .builder()
      .standardsControlAssociationDetails(
        standardsControlAssociationDetails.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .optionallyWith(
        unprocessedAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse
      .wrap(buildAwsValue())
}
object BatchGetStandardsControlAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse =
      zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse(
        standardsControlAssociationDetails.map { item =>
          item.asEditable
        },
        unprocessedAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def standardsControlAssociationDetails: List[
      zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly
    ]
    def unprocessedAssociations: Optional[List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly
    ]]
    def getStandardsControlAssociationDetails: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly
    ]] = ZIO.succeed(standardsControlAssociationDetails)
    def getUnprocessedAssociations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedAssociations",
      unprocessedAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse
  ) extends zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly {
    override val standardsControlAssociationDetails: List[
      zio.aws.securityhub.model.StandardsControlAssociationDetail.ReadOnly
    ] = impl
      .standardsControlAssociationDetails()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.StandardsControlAssociationDetail.wrap(item)
      }
      .toList
    override val unprocessedAssociations: Optional[List[
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.UnprocessedStandardsControlAssociation
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse
  ): zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
