package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2WebAclDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    managedbyFirewallManager: Optional[Boolean] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    capacity: Optional[Long] = Optional.Absent,
    captchaConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails
    ] = Optional.Absent,
    defaultAction: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclActionDetails
    ] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.securityhub.model.AwsWafv2RulesDetails]] =
      Optional.Absent,
    visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclDetails = {
    import AwsWafv2WebAclDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        managedbyFirewallManager.map(value => value: java.lang.Boolean)
      )(_.managedbyFirewallManager)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(capacity.map(value => value: java.lang.Long))(_.capacity)
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .optionallyWith(defaultAction.map(value => value.buildAwsValue()))(
        _.defaultAction
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(visibilityConfig.map(value => value.buildAwsValue()))(
        _.visibilityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafv2WebAclDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2WebAclDetails.wrap(buildAwsValue())
}
object AwsWafv2WebAclDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2WebAclDetails =
      zio.aws.securityhub.model.AwsWafv2WebAclDetails(
        name.map(value => value),
        arn.map(value => value),
        managedbyFirewallManager.map(value => value),
        id.map(value => value),
        capacity.map(value => value),
        captchaConfig.map(value => value.asEditable),
        defaultAction.map(value => value.asEditable),
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.map(value => value.asEditable)
      )
    def name: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def managedbyFirewallManager: Optional[Boolean]
    def id: Optional[NonEmptyString]
    def capacity: Optional[Long]
    def captchaConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly
    ]
    def defaultAction: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly
    ]
    def description: Optional[NonEmptyString]
    def rules: Optional[
      List[zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly]
    ]
    def visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getManagedbyFirewallManager: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("managedbyFirewallManager", managedbyFirewallManager)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getCapacity: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getCaptchaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("captchaConfig", captchaConfig)
    def getDefaultAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("defaultAction", defaultAction)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("visibilityConfig", visibilityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclDetails
  ) extends zio.aws.securityhub.model.AwsWafv2WebAclDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val managedbyFirewallManager: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedbyFirewallManager())
        .map(value => value: Boolean)
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val capacity: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => value: Long)
    override val captchaConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.captchaConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.wrap(value)
      )
    override val defaultAction: Optional[
      zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultAction())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2WebAclActionDetails.wrap(value)
      )
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rules: Optional[
      List[zio.aws.securityhub.model.AwsWafv2RulesDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafv2RulesDetails.wrap(item)
        }.toList
      )
    override val visibilityConfig: Optional[
      zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visibilityConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2VisibilityConfigDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclDetails
  ): zio.aws.securityhub.model.AwsWafv2WebAclDetails.ReadOnly = new Wrapper(
    impl
  )
}
