package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2CustomResponseDetails(
    customResponseBodyKey: Optional[NonEmptyString] = Optional.Absent,
    responseCode: Optional[Integer] = Optional.Absent,
    responseHeaders: Optional[
      Iterable[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomResponseDetails = {
    import AwsWafv2CustomResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomResponseDetails
      .builder()
      .optionallyWith(
        customResponseBodyKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customResponseBodyKey)
      .optionallyWith(responseCode.map(value => value: java.lang.Integer))(
        _.responseCode
      )
      .optionallyWith(
        responseHeaders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseHeaders)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2CustomResponseDetails
      .wrap(buildAwsValue())
}
object AwsWafv2CustomResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2CustomResponseDetails =
      zio.aws.securityhub.model.AwsWafv2CustomResponseDetails(
        customResponseBodyKey.map(value => value),
        responseCode.map(value => value),
        responseHeaders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customResponseBodyKey: Optional[NonEmptyString]
    def responseCode: Optional[Integer]
    def responseHeaders: Optional[
      List[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly]
    ]
    def getCustomResponseBodyKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customResponseBodyKey", customResponseBodyKey)
    def getResponseCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getResponseHeaders: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("responseHeaders", responseHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomResponseDetails
  ) extends zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly {
    override val customResponseBodyKey: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customResponseBodyKey())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val responseCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.responseCode())
      .map(value => value: Integer)
    override val responseHeaders: Optional[
      List[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responseHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomResponseDetails
  ): zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly =
    new Wrapper(impl)
}
