package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2ActionBlockDetails(
    customResponse: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomResponseDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionBlockDetails = {
    import AwsWafv2ActionBlockDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionBlockDetails
      .builder()
      .optionallyWith(customResponse.map(value => value.buildAwsValue()))(
        _.customResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.wrap(buildAwsValue())
}
object AwsWafv2ActionBlockDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionBlockDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafv2ActionBlockDetails =
      zio.aws.securityhub.model.AwsWafv2ActionBlockDetails(
        customResponse.map(value => value.asEditable)
      )
    def customResponse: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly
    ]
    def getCustomResponse: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly
    ] = AwsError.unwrapOptionField("customResponse", customResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionBlockDetails
  ) extends zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly {
    override val customResponse: Optional[
      zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customResponse())
      .map(value =>
        zio.aws.securityhub.model.AwsWafv2CustomResponseDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2ActionBlockDetails
  ): zio.aws.securityhub.model.AwsWafv2ActionBlockDetails.ReadOnly =
    new Wrapper(impl)
}
