package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalRuleGroupRulesActionDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails = {
    import AwsWafRegionalRuleGroupRulesActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalRuleGroupRulesActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails =
      zio.aws.securityhub.model
        .AwsWafRegionalRuleGroupRulesActionDetails(`type`.map(value => value))
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails
  ): zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesActionDetails.ReadOnly =
    new Wrapper(impl)
}
