package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails(
    minimumInstanceMetadataServiceVersion: Optional[NonEmptyString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails = {
    import AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
      .builder()
      .optionallyWith(
        minimumInstanceMetadataServiceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.minimumInstanceMetadataServiceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails =
      zio.aws.securityhub.model
        .AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails(
          minimumInstanceMetadataServiceVersion.map(value => value)
        )
    def minimumInstanceMetadataServiceVersion: Optional[NonEmptyString]
    def getMinimumInstanceMetadataServiceVersion
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "minimumInstanceMetadataServiceVersion",
      minimumInstanceMetadataServiceVersion
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly {
    override val minimumInstanceMetadataServiceVersion
        : Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumInstanceMetadataServiceVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails
  ): zio.aws.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
