package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterEndpoint(
    address: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint = {
    import AwsRedshiftClusterEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
      .builder()
      .optionallyWith(
        address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.wrap(buildAwsValue())
}
object AwsRedshiftClusterEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterEndpoint =
      zio.aws.securityhub.model.AwsRedshiftClusterEndpoint(
        address.map(value => value),
        port.map(value => value)
      )
    def address: Optional[NonEmptyString]
    def port: Optional[Integer]
    def getAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly {
    override val address: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterEndpoint
  ): zio.aws.securityhub.model.AwsRedshiftClusterEndpoint.ReadOnly =
    new Wrapper(impl)
}
