package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSecurityGroupIpRange(
    cidrIp: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange = {
    import AwsRdsDbSecurityGroupIpRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange
      .builder()
      .optionallyWith(
        cidrIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrIp)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.wrap(buildAwsValue())
}
object AwsRdsDbSecurityGroupIpRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange =
      zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange(
        cidrIp.map(value => value),
        status.map(value => value)
      )
    def cidrIp: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getCidrIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange
  ) extends zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly {
    override val cidrIp: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange
  ): zio.aws.securityhub.model.AwsRdsDbSecurityGroupIpRange.ReadOnly =
    new Wrapper(impl)
}
