package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceAssociatedRole(
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    featureName: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole = {
    import AwsRdsDbInstanceAssociatedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
      .builder()
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        featureName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.featureName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole
      .wrap(buildAwsValue())
}
object AwsRdsDbInstanceAssociatedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole =
      zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole(
        roleArn.map(value => value),
        featureName.map(value => value),
        status.map(value => value)
      )
    def roleArn: Optional[NonEmptyString]
    def featureName: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly {
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val featureName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ): zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly =
    new Wrapper(impl)
}
