package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(
    customEndpointCertificateArn: Optional[NonEmptyString] = Optional.Absent,
    customEndpointEnabled: Optional[Boolean] = Optional.Absent,
    enforceHTTPS: Optional[Boolean] = Optional.Absent,
    customEndpoint: Optional[NonEmptyString] = Optional.Absent,
    tlsSecurityPolicy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails = {
    import AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
      .builder()
      .optionallyWith(
        customEndpointCertificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customEndpointCertificateArn)
      .optionallyWith(
        customEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.customEndpointEnabled)
      .optionallyWith(enforceHTTPS.map(value => value: java.lang.Boolean))(
        _.enforceHTTPS
      )
      .optionallyWith(
        customEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customEndpoint)
      .optionallyWith(
        tlsSecurityPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tlsSecurityPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(
          customEndpointCertificateArn.map(value => value),
          customEndpointEnabled.map(value => value),
          enforceHTTPS.map(value => value),
          customEndpoint.map(value => value),
          tlsSecurityPolicy.map(value => value)
        )
    def customEndpointCertificateArn: Optional[NonEmptyString]
    def customEndpointEnabled: Optional[Boolean]
    def enforceHTTPS: Optional[Boolean]
    def customEndpoint: Optional[NonEmptyString]
    def tlsSecurityPolicy: Optional[NonEmptyString]
    def getCustomEndpointCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "customEndpointCertificateArn",
        customEndpointCertificateArn
      )
    def getCustomEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("customEndpointEnabled", customEndpointEnabled)
    def getEnforceHTTPS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforceHTTPS", enforceHTTPS)
    def getCustomEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customEndpoint", customEndpoint)
    def getTlsSecurityPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tlsSecurityPolicy", tlsSecurityPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly {
    override val customEndpointCertificateArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpointCertificateArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val customEndpointEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpointEnabled())
        .map(value => value: Boolean)
    override val enforceHTTPS: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enforceHTTPS())
      .map(value => value: Boolean)
    override val customEndpoint: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpoint())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val tlsSecurityPolicy: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsSecurityPolicy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
