package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsKmsKeyDetails(
    awsAccountId: Optional[NonEmptyString] = Optional.Absent,
    creationDate: Optional[Double] = Optional.Absent,
    keyId: Optional[NonEmptyString] = Optional.Absent,
    keyManager: Optional[NonEmptyString] = Optional.Absent,
    keyState: Optional[NonEmptyString] = Optional.Absent,
    origin: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    keyRotationStatus: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails = {
    import AwsKmsKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .optionallyWith(creationDate.map(value => value: java.lang.Double))(
        _.creationDate
      )
      .optionallyWith(
        keyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        keyManager.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyManager)
      .optionallyWith(
        keyState.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyState)
      .optionallyWith(
        origin.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.origin)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(keyRotationStatus.map(value => value: java.lang.Boolean))(
        _.keyRotationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsKmsKeyDetails.wrap(buildAwsValue())
}
object AwsKmsKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsKmsKeyDetails =
      zio.aws.securityhub.model.AwsKmsKeyDetails(
        awsAccountId.map(value => value),
        creationDate.map(value => value),
        keyId.map(value => value),
        keyManager.map(value => value),
        keyState.map(value => value),
        origin.map(value => value),
        description.map(value => value),
        keyRotationStatus.map(value => value)
      )
    def awsAccountId: Optional[NonEmptyString]
    def creationDate: Optional[Double]
    def keyId: Optional[NonEmptyString]
    def keyManager: Optional[NonEmptyString]
    def keyState: Optional[NonEmptyString]
    def origin: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def keyRotationStatus: Optional[Boolean]
    def getAwsAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getCreationDate: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyManager: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyManager", keyManager)
    def getKeyState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getOrigin: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("origin", origin)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getKeyRotationStatus: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyRotationStatus", keyRotationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ) extends zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly {
    override val awsAccountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val creationDate: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: Double)
    override val keyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyManager: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyManager())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyState: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyState())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val origin: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.origin())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyRotationStatus: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.keyRotationStatus())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKmsKeyDetails
  ): zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly = new Wrapper(impl)
}
