package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainLogPublishingOptions(
    indexSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = Optional.Absent,
    searchSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = Optional.Absent,
    auditLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions = {
    import AwsElasticsearchDomainLogPublishingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
      .builder()
      .optionallyWith(indexSlowLogs.map(value => value.buildAwsValue()))(
        _.indexSlowLogs
      )
      .optionallyWith(searchSlowLogs.map(value => value.buildAwsValue()))(
        _.searchSlowLogs
      )
      .optionallyWith(auditLogs.map(value => value.buildAwsValue()))(
        _.auditLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainLogPublishingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions =
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions(
        indexSlowLogs.map(value => value.asEditable),
        searchSlowLogs.map(value => value.asEditable),
        auditLogs.map(value => value.asEditable)
      )
    def indexSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def searchSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def auditLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def getIndexSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("indexSlowLogs", indexSlowLogs)
    def getSearchSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("searchSlowLogs", searchSlowLogs)
    def getAuditLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("auditLogs", auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly {
    override val indexSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
    override val searchSlowLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
    override val auditLogs: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.auditLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly =
    new Wrapper(impl)
}
