package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainElasticsearchClusterConfigDetails(
    dedicatedMasterCount: Optional[Integer] = Optional.Absent,
    dedicatedMasterEnabled: Optional[Boolean] = Optional.Absent,
    dedicatedMasterType: Optional[NonEmptyString] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails
    ] = Optional.Absent,
    zoneAwarenessEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails = {
    import AwsElasticsearchDomainElasticsearchClusterConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
      .builder()
      .optionallyWith(
        dedicatedMasterCount.map(value => value: java.lang.Integer)
      )(_.dedicatedMasterCount)
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(
        dedicatedMasterType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dedicatedMasterType)
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainElasticsearchClusterConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails =
      zio.aws.securityhub.model
        .AwsElasticsearchDomainElasticsearchClusterConfigDetails(
          dedicatedMasterCount.map(value => value),
          dedicatedMasterEnabled.map(value => value),
          dedicatedMasterType.map(value => value),
          instanceCount.map(value => value),
          instanceType.map(value => value),
          zoneAwarenessConfig.map(value => value.asEditable),
          zoneAwarenessEnabled.map(value => value)
        )
    def dedicatedMasterCount: Optional[Integer]
    def dedicatedMasterEnabled: Optional[Boolean]
    def dedicatedMasterType: Optional[NonEmptyString]
    def instanceCount: Optional[Integer]
    def instanceType: Optional[NonEmptyString]
    def zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ]
    def zoneAwarenessEnabled: Optional[Boolean]
    def getDedicatedMasterCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getDedicatedMasterType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly {
    override val dedicatedMasterCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dedicatedMasterCount())
      .map(value => value: Integer)
    override val dedicatedMasterEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterEnabled())
        .map(value => value: Boolean)
    override val dedicatedMasterType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails
          .wrap(value)
      )
    override val zoneAwarenessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
  ): zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly =
    new Wrapper(impl)
}
