package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentDetails(
    applicationName: Optional[NonEmptyString] = Optional.Absent,
    cname: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[NonEmptyString] = Optional.Absent,
    dateUpdated: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    endpointUrl: Optional[NonEmptyString] = Optional.Absent,
    environmentArn: Optional[NonEmptyString] = Optional.Absent,
    environmentId: Optional[NonEmptyString] = Optional.Absent,
    environmentLinks: Optional[Iterable[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
    ]] = Optional.Absent,
    environmentName: Optional[NonEmptyString] = Optional.Absent,
    optionSettings: Optional[Iterable[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
    ]] = Optional.Absent,
    platformArn: Optional[NonEmptyString] = Optional.Absent,
    solutionStackName: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    tier: Optional[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier
    ] = Optional.Absent,
    versionLabel: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails = {
    import AwsElasticBeanstalkEnvironmentDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        cname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cname)
      .optionallyWith(
        dateCreated.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        endpointUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpointUrl)
      .optionallyWith(
        environmentArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        environmentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentLinks)
      .optionallyWith(
        environmentName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        platformArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        solutionStackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        versionLabel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.versionLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails(
        applicationName.map(value => value),
        cname.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        description.map(value => value),
        endpointUrl.map(value => value),
        environmentArn.map(value => value),
        environmentId.map(value => value),
        environmentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentName.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformArn.map(value => value),
        solutionStackName.map(value => value),
        status.map(value => value),
        tier.map(value => value.asEditable),
        versionLabel.map(value => value)
      )
    def applicationName: Optional[NonEmptyString]
    def cname: Optional[NonEmptyString]
    def dateCreated: Optional[NonEmptyString]
    def dateUpdated: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def endpointUrl: Optional[NonEmptyString]
    def environmentArn: Optional[NonEmptyString]
    def environmentId: Optional[NonEmptyString]
    def environmentLinks: Optional[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]]
    def environmentName: Optional[NonEmptyString]
    def optionSettings: Optional[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]]
    def platformArn: Optional[NonEmptyString]
    def solutionStackName: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def tier: Optional[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ]
    def versionLabel: Optional[NonEmptyString]
    def getApplicationName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getCname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cname", cname)
    def getDateCreated: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointUrl", endpointUrl)
    def getEnvironmentArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getEnvironmentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentLinks: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentLinks", environmentLinks)
    def getEnvironmentName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getPlatformArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getSolutionStackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getVersionLabel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly {
    override val applicationName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cname: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dateUpdated: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val environmentId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentLinks: Optional[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
            .wrap(item)
        }.toList
      )
    override val environmentName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val optionSettings: Optional[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
            .wrap(item)
        }.toList
      )
    override val platformArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val solutionStackName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tier: Optional[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tier())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.wrap(value)
      )
    override val versionLabel: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly =
    new Wrapper(impl)
}
