package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEksClusterLoggingDetails(
    clusterLogging: Optional[Iterable[
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingDetails = {
    import AwsEksClusterLoggingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingDetails
      .builder()
      .optionallyWith(
        clusterLogging.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterLogging)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterLoggingDetails.wrap(buildAwsValue())
}
object AwsEksClusterLoggingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEksClusterLoggingDetails =
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails(
        clusterLogging.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterLogging: Optional[List[
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly
    ]]
    def getClusterLogging: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterLogging", clusterLogging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly {
    override val clusterLogging: Optional[List[
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterLogging())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingDetails
  ): zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly =
    new Wrapper(impl)
}
