package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEfsAccessPointRootDirectoryDetails(
    creationInfo: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
    ] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails = {
    import AwsEfsAccessPointRootDirectoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
      .builder()
      .optionallyWith(creationInfo.map(value => value.buildAwsValue()))(
        _.creationInfo
      )
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
      .wrap(buildAwsValue())
}
object AwsEfsAccessPointRootDirectoryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails =
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails(
        creationInfo.map(value => value.asEditable),
        path.map(value => value)
      )
    def creationInfo: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly
    ]
    def path: Optional[NonEmptyString]
    def getCreationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly
    ] = AwsError.unwrapOptionField("creationInfo", creationInfo)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
  ) extends zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly {
    override val creationInfo: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.creationInfo())
      .map(value =>
        zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
          .wrap(value)
      )
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
  ): zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly =
    new Wrapper(impl)
}
