package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEfsAccessPointDetails(
    accessPointId: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    clientToken: Optional[NonEmptyString] = Optional.Absent,
    fileSystemId: Optional[NonEmptyString] = Optional.Absent,
    posixUser: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails
    ] = Optional.Absent,
    rootDirectory: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointDetails = {
    import AwsEfsAccessPointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointDetails
      .builder()
      .optionallyWith(
        accessPointId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        clientToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        fileSystemId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fileSystemId)
      .optionallyWith(posixUser.map(value => value.buildAwsValue()))(
        _.posixUser
      )
      .optionallyWith(rootDirectory.map(value => value.buildAwsValue()))(
        _.rootDirectory
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEfsAccessPointDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEfsAccessPointDetails.wrap(buildAwsValue())
}
object AwsEfsAccessPointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEfsAccessPointDetails =
      zio.aws.securityhub.model.AwsEfsAccessPointDetails(
        accessPointId.map(value => value),
        arn.map(value => value),
        clientToken.map(value => value),
        fileSystemId.map(value => value),
        posixUser.map(value => value.asEditable),
        rootDirectory.map(value => value.asEditable)
      )
    def accessPointId: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def clientToken: Optional[NonEmptyString]
    def fileSystemId: Optional[NonEmptyString]
    def posixUser: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly
    ]
    def rootDirectory: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly
    ]
    def getAccessPointId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getClientToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFileSystemId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPosixUser: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly
    ] = AwsError.unwrapOptionField("posixUser", posixUser)
    def getRootDirectory: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("rootDirectory", rootDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointDetails
  ) extends zio.aws.securityhub.model.AwsEfsAccessPointDetails.ReadOnly {
    override val accessPointId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clientToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fileSystemId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val posixUser: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.posixUser())
      .map(value =>
        zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.wrap(value)
      )
    override val rootDirectory: Optional[
      zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDirectory())
      .map(value =>
        zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointDetails
  ): zio.aws.securityhub.model.AwsEfsAccessPointDetails.ReadOnly = new Wrapper(
    impl
  )
}
