package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcDetails(
    cidrBlockAssociationSet: Optional[
      Iterable[zio.aws.securityhub.model.CidrBlockAssociation]
    ] = Optional.Absent,
    ipv6CidrBlockAssociationSet: Optional[
      Iterable[zio.aws.securityhub.model.Ipv6CidrBlockAssociation]
    ] = Optional.Absent,
    dhcpOptionsId: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcDetails = {
    import AwsEc2VpcDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcDetails
      .builder()
      .optionallyWith(
        cidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockAssociationSet)
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .optionallyWith(
        dhcpOptionsId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dhcpOptionsId)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcDetails.wrap(buildAwsValue())
}
object AwsEc2VpcDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VpcDetails =
      zio.aws.securityhub.model.AwsEc2VpcDetails(
        cidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dhcpOptionsId.map(value => value),
        state.map(value => value)
      )
    def cidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly]
    ]
    def ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly]
    ]
    def dhcpOptionsId: Optional[NonEmptyString]
    def state: Optional[NonEmptyString]
    def getCidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cidrBlockAssociationSet",
      cidrBlockAssociationSet
    )
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
    def getDhcpOptionsId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dhcpOptionsId", dhcpOptionsId)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly {
    override val cidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.CidrBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.CidrBlockAssociation.wrap(item)
        }.toList
      )
    override val ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Ipv6CidrBlockAssociation.wrap(item)
        }.toList
      )
    override val dhcpOptionsId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dhcpOptionsId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcDetails
  ): zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly = new Wrapper(impl)
}
