package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2SubnetDetails(
    assignIpv6AddressOnCreation: Optional[Boolean] = Optional.Absent,
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    availabilityZoneId: Optional[NonEmptyString] = Optional.Absent,
    availableIpAddressCount: Optional[Integer] = Optional.Absent,
    cidrBlock: Optional[NonEmptyString] = Optional.Absent,
    defaultForAz: Optional[Boolean] = Optional.Absent,
    mapPublicIpOnLaunch: Optional[Boolean] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent,
    subnetArn: Optional[NonEmptyString] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    ipv6CidrBlockAssociationSet: Optional[
      Iterable[zio.aws.securityhub.model.Ipv6CidrBlockAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SubnetDetails = {
    import AwsEc2SubnetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SubnetDetails
      .builder()
      .optionallyWith(
        assignIpv6AddressOnCreation.map(value => value: java.lang.Boolean)
      )(_.assignIpv6AddressOnCreation)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        availabilityZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        availableIpAddressCount.map(value => value: java.lang.Integer)
      )(_.availableIpAddressCount)
      .optionallyWith(
        cidrBlock.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(defaultForAz.map(value => value: java.lang.Boolean))(
        _.defaultForAz
      )
      .optionallyWith(
        mapPublicIpOnLaunch.map(value => value: java.lang.Boolean)
      )(_.mapPublicIpOnLaunch)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        subnetArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetArn)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SubnetDetails.wrap(buildAwsValue())
}
object AwsEc2SubnetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SubnetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SubnetDetails =
      zio.aws.securityhub.model.AwsEc2SubnetDetails(
        assignIpv6AddressOnCreation.map(value => value),
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        availableIpAddressCount.map(value => value),
        cidrBlock.map(value => value),
        defaultForAz.map(value => value),
        mapPublicIpOnLaunch.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        subnetArn.map(value => value),
        subnetId.map(value => value),
        vpcId.map(value => value),
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def assignIpv6AddressOnCreation: Optional[Boolean]
    def availabilityZone: Optional[NonEmptyString]
    def availabilityZoneId: Optional[NonEmptyString]
    def availableIpAddressCount: Optional[Integer]
    def cidrBlock: Optional[NonEmptyString]
    def defaultForAz: Optional[Boolean]
    def mapPublicIpOnLaunch: Optional[Boolean]
    def ownerId: Optional[NonEmptyString]
    def state: Optional[NonEmptyString]
    def subnetArn: Optional[NonEmptyString]
    def subnetId: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly]
    ]
    def getAssignIpv6AddressOnCreation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "assignIpv6AddressOnCreation",
        assignIpv6AddressOnCreation
      )
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getAvailableIpAddressCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableIpAddressCount", availableIpAddressCount)
    def getCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getDefaultForAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultForAz", defaultForAz)
    def getMapPublicIpOnLaunch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mapPublicIpOnLaunch", mapPublicIpOnLaunch)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetArn", subnetArn)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SubnetDetails
  ) extends zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly {
    override val assignIpv6AddressOnCreation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignIpv6AddressOnCreation())
        .map(value => value: Boolean)
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val availabilityZoneId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val availableIpAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableIpAddressCount())
        .map(value => value: Integer)
    override val cidrBlock: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultForAz: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultForAz())
      .map(value => value: Boolean)
    override val mapPublicIpOnLaunch: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mapPublicIpOnLaunch())
      .map(value => value: Boolean)
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.securityhub.model.Ipv6CidrBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Ipv6CidrBlockAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SubnetDetails
  ): zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly = new Wrapper(impl)
}
