package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableKeySchema(
    attributeName: Optional[NonEmptyString] = Optional.Absent,
    keyType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema = {
    import AwsDynamoDbTableKeySchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        keyType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyType)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(buildAwsValue())
}
object AwsDynamoDbTableKeySchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableKeySchema =
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema(
        attributeName.map(value => value),
        keyType.map(value => value)
      )
    def attributeName: Optional[NonEmptyString]
    def keyType: Optional[NonEmptyString]
    def getAttributeName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getKeyType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyType", keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly {
    override val attributeName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema
  ): zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly = new Wrapper(
    impl
  )
}
