package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectSource(
    `type`: Optional[NonEmptyString] = Optional.Absent,
    location: Optional[NonEmptyString] = Optional.Absent,
    gitCloneDepth: Optional[Integer] = Optional.Absent,
    insecureSsl: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource = {
    import AwsCodeBuildProjectSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        location.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(gitCloneDepth.map(value => value: java.lang.Integer))(
        _.gitCloneDepth
      )
      .optionallyWith(insecureSsl.map(value => value: java.lang.Boolean))(
        _.insecureSsl
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectSource.wrap(buildAwsValue())
}
object AwsCodeBuildProjectSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectSource =
      zio.aws.securityhub.model.AwsCodeBuildProjectSource(
        `type`.map(value => value),
        location.map(value => value),
        gitCloneDepth.map(value => value),
        insecureSsl.map(value => value)
      )
    def `type`: Optional[NonEmptyString]
    def location: Optional[NonEmptyString]
    def gitCloneDepth: Optional[Integer]
    def insecureSsl: Optional[Boolean]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("location", location)
    def getGitCloneDepth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gitCloneDepth", gitCloneDepth)
    def getInsecureSsl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("insecureSsl", insecureSsl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val location: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val gitCloneDepth: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.gitCloneDepth())
      .map(value => value: Integer)
    override val insecureSsl: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.insecureSsl())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ): zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly = new Wrapper(
    impl
  )
}
