package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupRecoveryPointCreatedByDetails(
    backupPlanArn: Optional[NonEmptyString] = Optional.Absent,
    backupPlanId: Optional[NonEmptyString] = Optional.Absent,
    backupPlanVersion: Optional[NonEmptyString] = Optional.Absent,
    backupRuleId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCreatedByDetails = {
    import AwsBackupRecoveryPointCreatedByDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
      .builder()
      .optionallyWith(
        backupPlanArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanArn)
      .optionallyWith(
        backupPlanId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanId)
      .optionallyWith(
        backupPlanVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanVersion)
      .optionallyWith(
        backupRuleId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupRuleId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
      .wrap(buildAwsValue())
}
object AwsBackupRecoveryPointCreatedByDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails =
      zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails(
        backupPlanArn.map(value => value),
        backupPlanId.map(value => value),
        backupPlanVersion.map(value => value),
        backupRuleId.map(value => value)
      )
    def backupPlanArn: Optional[NonEmptyString]
    def backupPlanId: Optional[NonEmptyString]
    def backupPlanVersion: Optional[NonEmptyString]
    def backupRuleId: Optional[NonEmptyString]
    def getBackupPlanArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getBackupPlanId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanVersion", backupPlanVersion)
    def getBackupRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupRuleId", backupRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
  ) extends zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly {
    override val backupPlanArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val backupPlanId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val backupPlanVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val backupRuleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.backupRuleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
  ): zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly =
    new Wrapper(impl)
}
