package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupVaultNotificationsDetails(
    backupVaultEvents: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    snsTopicArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails = {
    import AwsBackupBackupVaultNotificationsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails
      .builder()
      .optionallyWith(
        backupVaultEvents.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.backupVaultEvents)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupVaultNotificationsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails =
      zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails(
        backupVaultEvents.map(value => value),
        snsTopicArn.map(value => value)
      )
    def backupVaultEvents: Optional[List[NonEmptyString]]
    def snsTopicArn: Optional[NonEmptyString]
    def getBackupVaultEvents: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("backupVaultEvents", backupVaultEvents)
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly {
    override val backupVaultEvents: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val snsTopicArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails
  ): zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly =
    new Wrapper(impl)
}
