package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanRuleCopyActionsDetails(
    destinationBackupVaultArn: Optional[NonEmptyString] = Optional.Absent,
    lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails = {
    import AwsBackupBackupPlanRuleCopyActionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
      .builder()
      .optionallyWith(
        destinationBackupVaultArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationBackupVaultArn)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupPlanRuleCopyActionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails =
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails(
        destinationBackupVaultArn.map(value => value),
        lifecycle.map(value => value.asEditable)
      )
    def destinationBackupVaultArn: Optional[NonEmptyString]
    def lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ]
    def getDestinationBackupVaultArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "destinationBackupVaultArn",
        destinationBackupVaultArn
      )
    def getLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly {
    override val destinationBackupVaultArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationBackupVaultArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycle())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly =
    new Wrapper(impl)
}
