package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociatedStandard(
    standardsId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AssociatedStandard = {
    import AssociatedStandard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AssociatedStandard
      .builder()
      .optionallyWith(
        standardsId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.standardsId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AssociatedStandard.ReadOnly =
    zio.aws.securityhub.model.AssociatedStandard.wrap(buildAwsValue())
}
object AssociatedStandard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AssociatedStandard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AssociatedStandard =
      zio.aws.securityhub.model
        .AssociatedStandard(standardsId.map(value => value))
    def standardsId: Optional[NonEmptyString]
    def getStandardsId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsId", standardsId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AssociatedStandard
  ) extends zio.aws.securityhub.model.AssociatedStandard.ReadOnly {
    override val standardsId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AssociatedStandard
  ): zio.aws.securityhub.model.AssociatedStandard.ReadOnly = new Wrapper(impl)
}
