package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{TagValue, TagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableSecurityHubRequest(
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    enableDefaultStandards: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest = {
    import EnableSecurityHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        enableDefaultStandards.map(value => value: java.lang.Boolean)
      )(_.enableDefaultStandards)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.EnableSecurityHubRequest.ReadOnly =
    zio.aws.securityhub.model.EnableSecurityHubRequest.wrap(buildAwsValue())
}
object EnableSecurityHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.EnableSecurityHubRequest =
      zio.aws.securityhub.model.EnableSecurityHubRequest(
        tags.map(value => value),
        enableDefaultStandards.map(value => value)
      )
    def tags: Optional[Map[TagKey, TagValue]]
    def enableDefaultStandards: Optional[Boolean]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableDefaultStandards: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableDefaultStandards", enableDefaultStandards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest
  ) extends zio.aws.securityhub.model.EnableSecurityHubRequest.ReadOnly {
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.TagKey(
              key
            ) -> zio.aws.securityhub.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val enableDefaultStandards: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultStandards())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest
  ): zio.aws.securityhub.model.EnableSecurityHubRequest.ReadOnly = new Wrapper(
    impl
  )
}
