package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomDataIdentifiersDetections(
    count: Optional[Long] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    occurrences: Optional[zio.aws.securityhub.model.Occurrences] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections = {
    import CustomDataIdentifiersDetections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly =
    zio.aws.securityhub.model.CustomDataIdentifiersDetections
      .wrap(buildAwsValue())
}
object CustomDataIdentifiersDetections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CustomDataIdentifiersDetections =
      zio.aws.securityhub.model.CustomDataIdentifiersDetections(
        count.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        occurrences.map(value => value.asEditable)
      )
    def count: Optional[Long]
    def arn: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def occurrences: Optional[zio.aws.securityhub.model.Occurrences.ReadOnly]
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ) extends zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly {
    override val count: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Long)
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val occurrences
        : Optional[zio.aws.securityhub.model.Occurrences.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.occurrences())
        .map(value => zio.aws.securityhub.model.Occurrences.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ): zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly =
    new Wrapper(impl)
}
