package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfiguration(
    errorDocument: Optional[NonEmptyString] = Optional.Absent,
    indexDocumentSuffix: Optional[NonEmptyString] = Optional.Absent,
    redirectAllRequestsTo: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
    ] = Optional.Absent,
    routingRules: Optional[Iterable[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration = {
    import AwsS3BucketWebsiteConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration
      .builder()
      .optionallyWith(
        errorDocument.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorDocument)
      .optionallyWith(
        indexDocumentSuffix.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.indexDocumentSuffix)
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration =
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration(
        errorDocument.map(value => value),
        indexDocumentSuffix.map(value => value),
        redirectAllRequestsTo.map(value => value.asEditable),
        routingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errorDocument: Optional[NonEmptyString]
    def indexDocumentSuffix: Optional[NonEmptyString]
    def redirectAllRequestsTo: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly
    ]
    def routingRules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly
    ]]
    def getErrorDocument: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorDocument", errorDocument)
    def getIndexDocumentSuffix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexDocumentSuffix", indexDocumentSuffix)
    def getRedirectAllRequestsTo: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly
    ] =
      AwsError.unwrapOptionField("redirectAllRequestsTo", redirectAllRequestsTo)
    def getRoutingRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly
    ]] = AwsError.unwrapOptionField("routingRules", routingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly {
    override val errorDocument: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDocument())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val indexDocumentSuffix: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexDocumentSuffix())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val redirectAllRequestsTo: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectAllRequestsTo())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRedirectTo
          .wrap(value)
      )
    override val routingRules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.routingRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRule
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly =
    new Wrapper(impl)
}
