package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbStatusInfo(
    statusType: Optional[NonEmptyString] = Optional.Absent,
    normal: Optional[Boolean] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    message: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo = {
    import AwsRdsDbStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
      .builder()
      .optionallyWith(
        statusType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.statusType)
      .optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbStatusInfo.wrap(buildAwsValue())
}
object AwsRdsDbStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbStatusInfo =
      zio.aws.securityhub.model.AwsRdsDbStatusInfo(
        statusType.map(value => value),
        normal.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def statusType: Optional[NonEmptyString]
    def normal: Optional[Boolean]
    def status: Optional[NonEmptyString]
    def message: Optional[NonEmptyString]
    def getStatusType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusType", statusType)
    def getNormal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("normal", normal)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ) extends zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly {
    override val statusType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.statusType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val normal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.normal())
      .map(value => value: Boolean)
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val message: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ): zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly = new Wrapper(impl)
}
