package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionLayer(
    arn: Optional[NonEmptyString] = Optional.Absent,
    codeSize: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer = {
    import AwsLambdaFunctionLayer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(codeSize.map(value => value: java.lang.Integer))(
        _.codeSize
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionLayer.wrap(buildAwsValue())
}
object AwsLambdaFunctionLayer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionLayer =
      zio.aws.securityhub.model.AwsLambdaFunctionLayer(
        arn.map(value => value),
        codeSize.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def codeSize: Optional[Integer]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCodeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("codeSize", codeSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val codeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer
  ): zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly = new Wrapper(
    impl
  )
}
