package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentTier(
    name: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier = {
    import AwsElasticBeanstalkEnvironmentTier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentTier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier(
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly =
    new Wrapper(impl)
}
