package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEfsAccessPointRootDirectoryCreationInfoDetails(
    ownerGid: Optional[NonEmptyString] = Optional.Absent,
    ownerUid: Optional[NonEmptyString] = Optional.Absent,
    permissions: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails = {
    import AwsEfsAccessPointRootDirectoryCreationInfoDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
      .builder()
      .optionallyWith(
        ownerGid.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerGid)
      .optionallyWith(
        ownerUid.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerUid)
      .optionallyWith(
        permissions.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.permissions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
      .wrap(buildAwsValue())
}
object AwsEfsAccessPointRootDirectoryCreationInfoDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails =
      zio.aws.securityhub.model
        .AwsEfsAccessPointRootDirectoryCreationInfoDetails(
          ownerGid.map(value => value),
          ownerUid.map(value => value),
          permissions.map(value => value)
        )
    def ownerGid: Optional[NonEmptyString]
    def ownerUid: Optional[NonEmptyString]
    def permissions: Optional[NonEmptyString]
    def getOwnerGid: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerGid", ownerGid)
    def getOwnerUid: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerUid", ownerUid)
    def getPermissions: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
  ) extends zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly {
    override val ownerGid: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerGid())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerUid: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerUid())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissions: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.permissions())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails
  ): zio.aws.securityhub.model.AwsEfsAccessPointRootDirectoryCreationInfoDetails.ReadOnly =
    new Wrapper(impl)
}
