package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableReplica(
    globalSecondaryIndexes: Optional[Iterable[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
    ]] = Optional.Absent,
    kmsMasterKeyId: Optional[NonEmptyString] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
    ] = Optional.Absent,
    regionName: Optional[NonEmptyString] = Optional.Absent,
    replicaStatus: Optional[NonEmptyString] = Optional.Absent,
    replicaStatusDescription: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica = {
    import AwsDynamoDbTableReplica.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
      .builder()
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        regionName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(
        replicaStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicaStatus)
      .optionallyWith(
        replicaStatusDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicaStatusDescription)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableReplica.wrap(buildAwsValue())
}
object AwsDynamoDbTableReplica {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableReplica =
      zio.aws.securityhub.model.AwsDynamoDbTableReplica(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        regionName.map(value => value),
        replicaStatus.map(value => value),
        replicaStatusDescription.map(value => value)
      )
    def globalSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]]
    def kmsMasterKeyId: Optional[NonEmptyString]
    def provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ]
    def regionName: Optional[NonEmptyString]
    def replicaStatus: Optional[NonEmptyString]
    def replicaStatusDescription: Optional[NonEmptyString]
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getKmsMasterKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getRegionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getReplicaStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaStatusDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicaStatusDescription",
        replicaStatusDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly {
    override val globalSecondaryIndexes: Optional[List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val kmsMasterKeyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val provisionedThroughputOverride: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
          .wrap(value)
      )
    override val regionName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replicaStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replicaStatusDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaStatusDescription())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ): zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly = new Wrapper(
    impl
  )
}
